package nemosofts.voxradio.utils.advertising;

import android.content.Context;
import android.util.Log;

import com.google.ads.consent.ConsentForm;
import com.google.ads.consent.ConsentFormListener;
import com.google.ads.consent.ConsentInfoUpdateListener;
import com.google.ads.consent.ConsentInformation;
import com.google.ads.consent.ConsentStatus;
import com.google.ads.consent.DebugGeography;

import java.net.MalformedURLException;
import java.net.URL;

import nemosofts.voxradio.BuildConfig;
import nemosofts.voxradio.callback.Callback;
import nemosofts.voxradio.interfaces.AdConsentListener;

public class AdConsent {

    private ConsentForm form;
    private final Context context;
    private final AdConsentListener adConsentListener;

    public AdConsent(Context context, AdConsentListener adConsentListener) {
        this.context = context;
        this.adConsentListener = adConsentListener;
    }

    public void checkForConsent() {
        ConsentInformation consentInformation = ConsentInformation.getInstance(context);
        String[] publisherIds = {Callback.publisherAdID};
        consentInformation.requestConsentInfoUpdate(publisherIds, new ConsentInfoUpdateListener() {
            @Override
            public void onConsentInfoUpdated(ConsentStatus consentStatus) {
                Log.d("consentStatus", consentStatus.toString());
                switch (consentStatus) {
                    case PERSONALIZED:
                    case NON_PERSONALIZED:
                        adConsentListener.onConsentUpdate();
                        break;
                    case UNKNOWN:
                        if (ConsentInformation.getInstance(context).isRequestLocationInEeaOrUnknown()) {
                            requestConsent();
                        } else {
                            adConsentListener.onConsentUpdate();
                        }
                        break;
                    default:
                        break;
                }
            }

            @Override
            public void onFailedToUpdateConsentInfo(String errorDescription) {
                // User's consent status failed to update.
            }
        });
    }

    public void requestConsent() {
        URL privacyUrl = null;
        try {
            privacyUrl = new URL(BuildConfig.BASE_URL+"privacy_policy.php");
        } catch (MalformedURLException e) {
            e.printStackTrace();
        }
        form = new ConsentForm.Builder(context, privacyUrl).withListener(new ConsentFormListener() {
                @Override
                public void onConsentFormLoaded() {
                    showForm();
                    // Consent form loaded successfully.
                }

                @Override
                public void onConsentFormOpened() {
                    // Consent form was displayed.
                }

                @Override
                public void onConsentFormClosed(ConsentStatus consentStatus, Boolean userPrefersAdFree) {
                    Log.d("consentStatus_form", consentStatus.toString());
                    adConsentListener.onConsentUpdate();
                }

                @Override
                public void onConsentFormError(String errorDescription) {
                    Log.d("errorDescription", errorDescription);
                }
            })
            .withPersonalizedAdsOption()
            .withNonPersonalizedAdsOption()
            .build();
        form.load();
    }

    private void showForm() {
        if (form != null) {
            form.show();
        }
    }

    public Boolean isUserFromEEA() {
        return ConsentInformation.getInstance(context).getDebugGeography() == DebugGeography.DEBUG_GEOGRAPHY_EEA;
    }
}
